/*
 * Decompiled with CFR 0.152.
 */
package org.python.indexer.ast;

import java.util.List;
import org.python.indexer.Indexer;
import org.python.indexer.NBinding;
import org.python.indexer.Scope;
import org.python.indexer.ast.NName;
import org.python.indexer.ast.NNode;
import org.python.indexer.ast.NNodeVisitor;
import org.python.indexer.types.NType;
import org.python.indexer.types.NUnknownType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NGlobal
extends NNode {
    static final long serialVersionUID = 5978320165592263568L;
    public List<NName> names;

    public NGlobal(List<NName> list) {
        this(list, 0, 1);
    }

    public NGlobal(List<NName> list, int n, int n2) {
        super(n, n2);
        this.names = list;
        this.addChildren(list);
    }

    @Override
    public NType resolve(Scope scope) throws Exception {
        Scope scope2 = scope.getGlobalTable();
        for (NName nName : this.names) {
            if (scope.isGlobalName(nName.id)) continue;
            scope.addGlobalName(nName.id);
            NBinding nBinding = scope2.lookup(nName);
            if (nBinding == null) {
                nBinding = scope2.put(nName.id, null, new NUnknownType(), NBinding.Kind.SCOPE);
            }
            Indexer.idx.putLocation(nName, nBinding);
        }
        return this.getType();
    }

    public String toString() {
        return "<Global:" + this.names + ">";
    }

    @Override
    public void visit(NNodeVisitor nNodeVisitor) {
        if (nNodeVisitor.visit(this)) {
            this.visitNodeList(this.names, nNodeVisitor);
        }
    }
}

